/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.io.IOUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.TypedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BootstrapSettings {
    private static File file = null;
    private static TypedProperties props = null;

    public static void addHistory(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            return;
        }
        List<String> history = BootstrapSettings.getHistory();
        if (history.contains(dir)) {
            history.remove(dir);
        }
        history.add(0, dir);
        int histSize = BootstrapSettings.getProperties().getInt("size", 8);
        if (history.size() > histSize) {
            history = history.subList(0, histSize);
        }
        BootstrapSettings.getProperties().setList("history", history.toArray(new String[history.size()]));
        BootstrapSettings.store();
    }

    public static List<String> getHistory() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(BootstrapSettings.getProperties().getList("history", new String[0])));
        return result;
    }

    public static String getProperty(String name, String defaultValue) {
        return BootstrapSettings.getProperties().getString(name, defaultValue);
    }

    public static void setProperty(String name, String value) {
        BootstrapSettings.getProperties().setProperty(name, value);
        BootstrapSettings.store();
    }

    public static boolean getAskWorkdir() {
        return Boolean.parseBoolean(BootstrapSettings.getProperty("ask", "true"));
    }

    public static void setAskWorkdir(boolean b) {
        BootstrapSettings.setProperty("ask", Boolean.toString(b));
        BootstrapSettings.store();
    }

    private static synchronized TypedProperties getProperties() {
        if (props != null) {
            return props;
        }
        props = new TypedProperties();
        File f = BootstrapSettings.getFile();
        if (!(f.exists() && f.isFile() && f.canRead())) {
            return props;
        }
        Logger.info((String)("reading " + f));
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            props.load((InputStream)is);
        }
        catch (Exception e) {
            try {
                Logger.error((String)("unable to load " + f + " - ignoring file"), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is});
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
        return props;
    }

    private static synchronized void store() {
        BufferedOutputStream os = null;
        File f = BootstrapSettings.getFile();
        try {
            Logger.info((String)("writing " + f));
            os = new BufferedOutputStream(new FileOutputStream(f));
            props.store((OutputStream)os, "created by " + System.getProperty("user.name"));
        }
        catch (Exception e) {
            try {
                Logger.error((String)("unable to store " + f + " - ignoring"), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
        IOUtil.close((Closeable[])new Closeable[]{os});
    }

    private static synchronized File getFile() {
        if (file == null) {
            file = new File(System.getProperty("user.home"), ".jameica.properties");
            String xdg = System.getenv("XDG_CONFIG_HOME");
            if (!file.canRead() && xdg != null) {
                file = new File(xdg, "jameica.properties");
            }
        }
        return file;
    }
}

